


### Question 1

**Which statement best describes the primary architectural concept of Software-Defined Networking (SDN)?**

A. The data plane is virtualized and managed by each device independently.  
B. The control and data planes are decoupled, with centralized intelligence.  
C. All network functions are performed in hardware for maximum performance.  
D. Network devices use proprietary protocols for device management.














**Correct Answer:**  
B. The control and data planes are decoupled, with centralized intelligence.

**Reason:**  
SDN separates the control plane from the data plane and centralizes network intelligence for easier management and automation.











---

### Question 2

**What is a main benefit of using a centralized SDN controller in a network?**

A. Increases manual configuration requirements  
B. Allows for programmatic network management and automation  
C. Makes each network device autonomous  
D. Reduces network scalability




















**Correct Answer:**  
B. Allows for programmatic network management and automation

**Reason:**  
A centralized SDN controller enables network-wide programmability and automation, reducing manual intervention.






















---

### Question 3

**Which of the following is NOT typically considered a building block of SDN?**

A. SDN Controller  
B. Northbound APIs  
C. Southbound APIs  
D. Network Interface Cards (NICs)















**Correct Answer:**  
D. Network Interface Cards (NICs)

**Reason:**  
The core SDN building blocks are the controller, northbound APIs, and southbound APIs, not physical NIC hardware.














---

### Question 4

**Which protocol is commonly used as a southbound interface between an SDN controller and network devices?**

A. OpenFlow  
B. SNMP  
C. OSPF  
D. BGP

















**Correct Answer:**  
A. OpenFlow

**Reason:**  
OpenFlow is specifically designed as a southbound protocol for SDN controllers to communicate with network devices.


















---

### Question 5

**What is the primary purpose of Cisco Network Services Orchestrator (NSO)?**

A. Provides wireless access point management  
B. Automates and orchestrates network services across traditional and virtualized networks  
C. Functions as a WAN optimization appliance  
D. Acts as a network firewall for data centers

















**Correct Answer:**  
B. Automates and orchestrates network services across traditional and virtualized networks

**Reason:**  
Cisco NSO is designed to automate and orchestrate network service provisioning and lifecycle management.



















---

### Question 6

**In a hybrid SDN approach, what is a significant advantage compared to a pure SDN or pure traditional network?**

A. It eliminates the need for traditional routing protocols and making deployment easier.
B. It allows selective use of SDN and traditional protocols for greater flexibility  
C. It requires all devices to be "dumb" forwarding elements  
D. It cannot utilize APIs for management


















**Correct Answer:**  
B. It allows selective use of SDN and traditional protocols for greater flexibility

**Reason:**  
Hybrid SDN leverages the strengths of both models, enabling gradual migration and flexible management.
















---

### Question 7

**Which open-source project provides a virtual switch commonly used with hypervisors for connecting virtual machines?**

A. OpenStack Neutron  
B. Open vSwitch (OvS)  
C. Contiv  
D. OpenSwitch (OSW)
















**Correct Answer:**  
B. Open vSwitch (OvS)

**Reason:**  
Open vSwitch (OvS) is designed as a virtual switch for hypervisor environments to interconnect VMs.


















---

### Question 8

**Which tool or protocol is typically used for on-box programmability on Cisco platforms?**

A. NETCONF  
B. Python  
C. RESTCONF  
D. OpenFlow



















**Correct Answer:**  
B. Python

**Reason:**  
Python scripting is widely supported on Cisco devices for on-box automation and programmability.















---

### Question 9

**What is the main role of northbound APIs in an SDN architecture?**

A. They connect the controller to physical switches and routers in the environment
B. They enable the controller to communicate with applications and services  
C. They provide direct access to the ASICs on devices  
D. They configure individual network interface cards















**Correct Answer:**  
B. They enable the controller to communicate with applications and services

**Reason:**  
Northbound APIs allow applications and services to interact programmatically with the SDN controller.














### Question 10

**In a typical network automation workflow, what step usually follows a successful code review of configuration changes?**

A. The changes are ignored  
B. The configuration is deployed to production devices  
C. The branch is deleted  
D. The device is rebooted














**Correct Answer:**  
B. The configuration is deployed to production devices

**Reason:**  
After code review, the next step is to deploy the approved configuration changes to the network devices.
















---

### Question 11

**Which protocol is commonly used for real-time telemetry and management of modern network devices?**

A. Telnet  
B. NETCONF  
C. FTP  
D. SMTP




















**Correct Answer:**  
B. NETCONF

**Reason:**  
NETCONF is a modern protocol designed for real-time management and configuration of network devices.















---

### Question 12

**Which open-source tool is frequently used to automate network device configuration and management?**

A. Ansible  
B. Microsoft Word  
C. Adobe Photoshop  
D. Cisco Packet Tracer



















**Correct Answer:**  
A. Ansible

**Reason:**  
Ansible is widely used for automating the configuration and management of network devices.


















---

### Question 13



**Which API is supported by Cisco IOS XE platforms for network programmability?**

A. gRPC  
B. NETCONF  
C. NX-API CLI  
D. OpenFlow














**Correct Answer:**  
B. NETCONF

**Reason:**  
Cisco IOS XE supports NETCONF (as well as RESTCONF) for programmable device management.


















---

### Question 14

**What is the primary function of the Cisco Secure Firewall Management Center REST API?**

A. Hardware monitoring only  
B. Programmatic management of firewall configurations and operations  
C. Give access to the southbound API for the SDN controller
D. CLI-only access to firewall devices
















**Correct Answer:**  
B. Programmatic management of firewall configurations and operations

**Reason:**  
The REST API enables remote, programmatic access to manage, configure, and retrieve information from the firewall management center.















---

### Question 15

**Which authentication method is used by the Cisco Secure Firewall Management Center REST API?**

A. SNMP community strings  
B. Token-based authentication  
C. Telnet login  
D. SSH keys authentication














**Correct Answer:**  
B. Token-based authentication

**Reason:**  
REST API uses access tokens, obtained by username/password, to authenticate and authorize API calls.


















---

### Question 16

**Which protocol(s) are commonly used by Cisco IOS XR platforms for off-box programmability?**

A. NETCONF and gRPC  
B. SNMP and FTP  
C. Telnet and HTTP  
D. OpenFlow and SMTP





















**Correct Answer:**  
A. NETCONF and gRPC

**Reason:**  
Cisco IOS XR supports NETCONF, RESTCONF, and gRPC for network programmability and automation.























---

### Question 17

**Which HTTP method is NOT supported by the Cisco Secure Firewall Management Center REST API?**

A. POST  
B. PATCH  
C. PUT  
D. DELETE

















**Correct Answer:**  
B. PATCH

**Reason:**  
PATCH is not supported; only GET, POST, PUT, and DELETE are available methods.

---









### Question 18


**Why is Python commonly used for network automation on Cisco devices?**

A. It is compiled for maximum speed  
B. It requires proprietary Cisco software which the devices already come with.
C. It is natively supported on many Cisco platforms  
D. It only runs on Windows servers
















**Correct Answer:**  
C. It is simple, powerful, and natively supported on many Cisco platforms

**Reason:**  
Python’s simplicity and Cisco’s built-in support make it ideal for automation tasks.
















---

### Question 19


**What is the primary benefit of using Swagger CodeGen with the Open API Spec for Cisco Secure Firewall Management Center?**

A. It automatically deploys firewall rules using the REST API endpoints
B. It generates sample code for all supported REST API endpoints  
C. It updates device firmware  
D. It encrypts all API communications for use with REST API 













**Correct Answer:**  
B. It generates sample code for all supported REST API endpoints

**Reason:**  
Swagger CodeGen creates starter code in various languages based on the API specification.











---

### Question 20

**Which of the following tasks can be automated with Python scripts and the Cisco Secure Firewall Management Center REST API?**

A. Device registration and policy creation  
B. Physical cable installation  
C. Power supply replacement  
D. Manual GUI login















**Correct Answer:**  
A. Device registration and policy creation

**Reason:**  
Python scripts can use the REST API to automate registration, object creation, and policy tasks.

---
